/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.kintai.dao.CmRotationDao;
import jp.mosp.kintai.dto.CmRotationDto;
import jp.mosp.kintai.vo.ScheduleRotationListVo;

public class ScheduleRotationListAction extends MosPAction {

	//R}h
	private static final String CMD_ROTATION_LIST_SHOW      	= "K1210";	// \
	private static final String CMD_ROTATION_LIST_SEARCH    	= "K1211";	// 
	private static final String CMD_ROTATION_LIST__RE_SEARCH 	= "K1212";	// Č
	private static final String CMD_ROTATION_LIST_SORT      	= "K1213";	// \[g

	/**
	 * RXgN^
	 */
	public ScheduleRotationListAction() {
		super();
	}

	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// VO̎擾
		ScheduleRotationListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof ScheduleRotationListVo) {
			vo = (ScheduleRotationListVo) obj;
			vo.clearMessage();
			vo.clearErrField();
		} else {
			vo = new ScheduleRotationListVo();
		}
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		//VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());	
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R[h敪v_EXg쐬
		vo.aryPltWorkType = getWorkTypeArrayWithWeekHoliday();
		vo.aryPltHoliday  = getApplicableFlagArray();
		// [U[擾
		getInfo(user.getUserId());
		//R}h̏
		if (cmd.equals(CMD_ROTATION_LIST_SHOW)){
			//lɃZbg
			vo.setSearchmode(ScheduleRotationListVo.SEARCH_OFF);			
		} else if (cmd.equals(CMD_ROTATION_LIST_SEARCH)) {
			//
			vo.setParams(request);
			searchFmRotationList(vo);
			vo.setFormerKey(vo.KEY_RT_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
			//ɃZbg
			vo.setSearchmode(ScheduleRotationListVo.SEARCH_ON);			
		} else if (cmd.equals(CMD_ROTATION_LIST__RE_SEARCH)) {
			//Č
			if(vo.getSearchmode() == ScheduleRotationListVo.SEARCH_ON){
				session.removeAttribute(MospConst.ATT_DTO);
				searchFmRotationList(vo);
				vo.setPageButton();
				sortList(vo);		
			}			
		} else if (cmd.equals(CMD_ROTATION_LIST_SORT)){
			//\[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ֔ԃp^[Xg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchFmRotationList(ScheduleRotationListVo vo) throws Exception {
		// 
		CmRotationDao dao = new CmRotationDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition(mKihon.getKCode(), vo.getTxtRTCode(), vo.getTxtRTName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryRTCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, ScheduleRotationListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(ScheduleRotationListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator getComparator(String key, ScheduleRotationListVo vo) throws MospException {
		Comparator comp = null;
		if (key.equals(vo.KEY_RT_CODE)) {
			comp = new CompFmRotationCode();
		} else if (key.equals(vo.KEY_RT_NAME)) {
			comp = new CompFmRotationName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ̂ɂrNX
	 */
	protected static class CompFmRotationName implements Comparator, Serializable {
		private static final long serialVersionUID = -4433257333577061313L;
		public int compare(Object obj1, Object obj2) {
			CmRotationDto dto1 = (CmRotationDto)obj1;
			CmRotationDto dto2 = (CmRotationDto)obj2;
			return dto1.getRtName().compareTo(dto2.getRtName());
		}
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompFmRotationCode implements Comparator, Serializable {
		private static final long serialVersionUID = 4002773790452263008L;
		public int compare(Object obj1, Object obj2) {
			CmRotationDto dto1 = (CmRotationDto)obj1;
			CmRotationDto dto2 = (CmRotationDto)obj2;
			return dto1.getRtCode().compareTo(dto2.getRtCode());
		}
	}

}
